/*
 * Decompiled with CFR 0.152.
 */
public class VectorCalculus {
    float x;
    float y;
    float z;
    VectorCalculus vector_product;
    VectorCalculus vect_1;
    VectorCalculus vect_2;
    float scalar_product;

    public VectorCalculus() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public VectorCalculus(float a, float b, float c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public VectorCalculus(float[] point1) {
        this.x = point1[0];
        this.y = point1[1];
        this.z = point1[2];
    }

    public VectorCalculus(float[] point1, float[] point2) {
        this.x = point2[0] - point1[0];
        this.y = point2[1] - point1[1];
        this.z = point2[2] - point1[2];
    }

    public VectorCalculus(VectorCalculus point1, VectorCalculus point2) {
        this.x = point2.x - point1.x;
        this.y = point2.y - point1.y;
        this.z = point2.z - point1.z;
    }

    public float dotProduct(VectorCalculus v1, VectorCalculus v2) {
        float v1_x = v1.x;
        float v1_y = v1.y;
        float v1_z = v1.z;
        float v2_x = v2.x;
        float v2_y = v2.y;
        float v2_z = v2.z;
        this.scalar_product = v1_x * v2_x + v1_y * v2_y + v1_z * v2_z;
        return this.scalar_product;
    }

    public VectorCalculus crossProduct(VectorCalculus v1, VectorCalculus v2) {
        if (this.vector_product == null) {
            this.vector_product = new VectorCalculus();
        }
        this.vector_product.x = v1.y * v2.z - v1.z * v2.y;
        this.vector_product.y = v1.z * v2.x - v1.x * v2.z;
        this.vector_product.z = v1.x * v2.y - v1.y * v2.x;
        return this.vector_product;
    }

    public VectorCalculus addVector(VectorCalculus v1, VectorCalculus v2) {
        if (this.vector_product == null) {
            this.vector_product = new VectorCalculus();
        }
        this.vector_product.x = v1.x + v2.x;
        this.vector_product.y = v1.y + v2.y;
        this.vector_product.z = v1.z + v2.z;
        return this.vector_product;
    }

    public VectorCalculus subtractVector(VectorCalculus v1, VectorCalculus v2) {
        if (this.vector_product == null) {
            this.vector_product = new VectorCalculus();
        }
        this.vector_product.x = v1.x - v2.x;
        this.vector_product.y = v1.y - v2.y;
        this.vector_product.z = v1.z - v2.z;
        return this.vector_product;
    }

    public VectorCalculus unitVector(VectorCalculus v1) {
        float v1_x = v1.x;
        float v1_y = v1.y;
        float v1_z = v1.z;
        if (this.vector_product == null) {
            this.vector_product = new VectorCalculus();
        }
        this.scalar_product = (float)Math.sqrt(v1_x * v1_x + v1_y * v1_y + v1_z * v1_z);
        this.scalar_product = 1.0f / this.scalar_product;
        this.vector_product.x = v1_x * this.scalar_product;
        this.vector_product.y = v1_y * this.scalar_product;
        this.vector_product.z = v1_z * this.scalar_product;
        return this.vector_product;
    }

    public VectorCalculus normalVector(float[] point1, float[] point2, boolean unitNormal) {
        this.vect_1 = new VectorCalculus();
        this.vect_2 = new VectorCalculus();
        this.vect_1.x = 0.0f;
        this.vect_1.y = 0.0f;
        this.vect_1.z = 1.0f;
        this.vect_2.x = point2[0] - point1[0];
        this.vect_2.y = point2[1] - point1[1];
        this.vect_2.z = point2[2] - point1[2];
        this.vector_product = this.crossProduct(this.vect_2, this.vect_1);
        if (unitNormal) {
            this.vector_product = this.unitVector(this.vector_product);
        }
        this.vect_1 = null;
        this.vect_2 = null;
        return this.vector_product;
    }

    public VectorCalculus normalVector(float[] point1, float[] point2, float[] point3, boolean unitNormal) {
        this.vect_1 = new VectorCalculus();
        this.vect_2 = new VectorCalculus();
        this.vect_1.x = point1[0] - point2[0];
        this.vect_1.y = point1[1] - point2[1];
        this.vect_1.z = point1[2] - point2[2];
        this.vect_2.x = point3[0] - point2[0];
        this.vect_2.y = point3[1] - point2[1];
        this.vect_2.z = point3[2] - point2[2];
        this.vector_product = this.crossProduct(this.vect_2, this.vect_1);
        if (unitNormal) {
            this.vector_product = this.unitVector(this.vector_product);
        }
        this.vect_1 = null;
        this.vect_2 = null;
        return this.vector_product;
    }

    public VectorCalculus invertVector(VectorCalculus v1) {
        v1.x = -v1.x;
        v1.y = -v1.y;
        v1.z = -v1.z;
        return v1;
    }

    public float magnitude(VectorCalculus v1) {
        this.scalar_product = (float)Math.sqrt(v1.x * v1.x + v1.y * v1.y + v1.z * v1.z);
        return this.scalar_product;
    }
}

